/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

import java.util.Arrays;
import java.util.List;

import org.everit.json.schema.Schema;

public class RestHandlerManager {

  private MetadataFormat metadataFormat;

  public RestHandlerManager(MetadataFormat metadataFormat) {
    this.metadataFormat = metadataFormat;
  }

  private List<? extends SchemaHandler> handlers =
      Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(),
                    new EnumHandler(),
                    new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(),
                    new StringHandler());

  public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
    if (parsingContext.isAlreadyBuild(schema)) {
      return parsingContext.getBuilder(schema).orElse(null);
    } else {
      for (SchemaHandler handler : handlers) {
        if (handler.handles(schema)) {
          return handler.handle(schema, BaseTypeBuilder.create(metadataFormat), this, parsingContext);
        }
      }
      // If no type was detected we just generate any
      return BaseTypeBuilder.create(metadataFormat).anyType();
    }
  }
}
