/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.data.sample;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.internal.adapter.SdkResultAdapter;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RestSampleDataProvider<T, A>
implements SampleDataProvider<T, A> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestSampleDataProvider.class);
    @Config
    private RestConfiguration config;
    @Connection
    protected RestConnection connection;
    @Inject
    protected ExpressionLanguage expressionLanguage;

    public String getId() {
        return this.getClass().getSimpleName();
    }

    public Result<T, A> getSample() throws SampleDataException {
        org.mule.runtime.extension.api.runtime.operation.Result<TypedValue<String>, HttpResponseAttributes> resultCall = this.getResult();
        Result result = SdkResultAdapter.from(resultCall);
        return result;
    }

    protected org.mule.runtime.extension.api.runtime.operation.Result<TypedValue<String>, HttpResponseAttributes> getResult() {
        return RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, this.getRestRequestBuilder(), this.getDefaultResponseMediaType());
    }

    protected abstract String getPathTemplate();

    protected abstract RestRequestBuilder getRequestBuilder(String var1);

    protected abstract RequestParameterBinding getParameterBinding();

    protected abstract MultiMap<String, TypedValue<?>> getParameterValues();

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    private RestRequestBuilder getRestRequestBuilder() {
        RequestParameterBinding parameterBinding = this.getParameterBinding();
        RestRequestBuilder requestBuilder = this.getRequestBuilder(this.buildRequestPath(this.getPathTemplate(), parameterBinding.getUriParams()));
        parameterBinding.getHeaders().forEach(i -> requestBuilder.addHeader(i.getKey(), this.getParameterValue(i.getValue())));
        parameterBinding.getQueryParams().forEach(i -> requestBuilder.addQueryParam(i.getKey(), this.getParameterValue(i.getValue())));
        return requestBuilder;
    }

    private String buildRequestPath(String pathTemplate, List<RequestParameterBinding.Binding> uriParams) {
        if (uriParams.isEmpty()) {
            return pathTemplate;
        }
        HashMap uriParamValues = new HashMap();
        uriParams.forEach(i -> uriParamValues.put(i.getKey(), this.getParameterValue(i.getValue())));
        String path = pathTemplate;
        for (String key : uriParamValues.keySet()) {
            path = path.replace("{" + key + "}", (CharSequence)uriParamValues.get(key));
        }
        return path;
    }

    private String getParameterValue(String expression) {
        return (String)this.expressionLanguage.evaluate(expression, DataType.STRING, this.buildContext(null)).getValue();
    }

    protected BindingContext buildContext(TypedValue<?> payload) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", payload);
        return builder.build();
    }
}

