/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.data.sample;

import static org.mule.runtime.api.el.BindingContext.builder;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.runtime.operation.Result;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.util.FromCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;

import java.io.InputStream;
import java.util.Iterator;

public abstract class RestSampleDataProviderTrigger
    extends RestSampleDataProvider<TypedValue<InputStream>, HttpResponseAttributes> {

  protected final String itemsExpression;


  protected RestSampleDataProviderTrigger(String itemsExpression) {
    this.itemsExpression = itemsExpression;
  }

  @Override
  public Result<TypedValue<InputStream>, HttpResponseAttributes> getSample() throws SampleDataException {
    org.mule.runtime.extension.api.runtime.operation.Result<TypedValue<String>, HttpResponseAttributes> resultCall = getResult();
    TypedValue<String> payload = resultCall.getOutput();
    TypedValue<CursorStreamProvider> item = getItem(payload);

    TypedValue<InputStream> inputStreamTypedValue =
        new TypedValue<>(FromCursorProviderInputStream.of(item.getValue()), item.getDataType());

    Result<TypedValue<InputStream>, HttpResponseAttributes> responseResult =
        Result.<TypedValue<InputStream>, HttpResponseAttributes>builder()
            .output(inputStreamTypedValue)
            .attributes(resultCall.getAttributes().orElse(null))
            .build();

    return responseResult;
  }

  //TODO tech debt: go over RestPollingSource and check if we can unify this behaviour
  private TypedValue<CursorStreamProvider> getItem(TypedValue<String> payload) {
    TypedValue<?> result =
        expressionLanguage.evaluate(itemsExpression, buildContext(payload));

    Iterator<TypedValue<?>> splitResult =
        expressionLanguage.split("#[payload default []]", buildSplitContext(result));
    return splitResult.hasNext() ? RequestStreamingUtils.getCursorStreamProviderValueFromSplitResult(splitResult.next()) : null;
  }

  //TODO tech debt: go over RestPollingSource and check if we can unify this behaviour
  @Override
  protected BindingContext buildContext(TypedValue<?> payload) {
    BindingContext.Builder builder = builder()
        .addBinding("payload", payload)
        .addBinding("parameter", TypedValue.of(getParameterValues()));
    return builder.build();
  }

  //TODO tech debt: go over RestPollingSource and check if we can unify this behaviour
  private BindingContext buildSplitContext(TypedValue<?> payload) {
    return builder().addBinding("payload", TypedValue.of(payload)).build();
  }

}
