/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static java.util.regex.Pattern.compile;

import java.util.regex.Pattern;

/**
 * Utils class for DW expressions
 *
 * @since 1.0
 */
public class DwUtils {

  private DwUtils() {}

  private final static Pattern dwInvalidChars = compile("[^a-zA-Z0-9_]");

  /**
   * Transforms a name into a valid DW identifier
   * @param name The name to transform
   * @return A valid DW identifier
   */
  public static String getDwIdentifier(String name) {
    while (dwInvalidChars.matcher(name).find()) {
      name = dwInvalidChars.matcher(name).replaceAll("_");
    }

    return "dw" + name;
  }

  /**
   * Checks if a provided string has the format of a DataWeave expression.
   * This does not check if it is a valid expression or not.
   * @param str The string to check
   * @return Wherever this is an expression or not.
   */
  public static boolean isExpression(String str) {
    return str.toLowerCase().trim().startsWith("#[")
        && str.toLowerCase().trim().endsWith("]");
  }
}
