/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.queryparam;

import static java.lang.String.join;
import org.mule.runtime.api.util.MultiMap;

/***
 * A {@link QueryParamFormatter} that formats the query parameters multimap so arrays are split with commas
 * i.e queryParam1=value1,value2&queryParam2=value3
 *
 * @since 1.0
 */
public class CommaQueryParamFormatter implements QueryParamFormatter {

  @Override
  public MultiMap<String, String> format(MultiMap<String, String> queryParams) {
    MultiMap<String, String> formatted = new MultiMap<>();

    for (String queryParam : queryParams.keySet()) {
      if (!formatted.containsKey(queryParam)) {
        formatted.put(queryParam, join(",", queryParams.getAll(queryParam)));
      }
    }

    return formatted;
  }
}
