/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.valueprovider;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.source.RequestParameterBinding;
import com.mulesoft.connectivity.rest.commons.internal.util.RequestStreamingUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public abstract class RestValueProvider
implements ValueProvider {
    @Config
    private RestConfiguration config;
    @Connection
    protected RestConnection connection;
    @Inject
    private ExpressionLanguage expressionLanguage;
    protected final String itemsExpression;
    protected final String itemValueExpression;
    protected final String itemNameExpression;

    public RestValueProvider(String itemsExpression, String itemValueExpression, String itemNameExpression) {
        Objects.requireNonNull(itemsExpression);
        Objects.requireNonNull(itemValueExpression);
        this.itemsExpression = itemsExpression;
        this.itemValueExpression = itemValueExpression;
        this.itemNameExpression = itemNameExpression;
    }

    protected abstract RequestParameterBinding getParameterBinding();

    protected abstract String getPathTemplate();

    protected abstract RestRequestBuilder getRequestBuilder(String var1);

    private RestRequestBuilder getRestRequestBuilder() {
        RequestParameterBinding parameterBinding = this.getParameterBinding();
        RestRequestBuilder requestBuilder = this.getRequestBuilder(this.buildRequestPath(this.getPathTemplate(), parameterBinding.getUriParams()));
        parameterBinding.getHeaders().forEach(i -> requestBuilder.addHeader(i.getKey(), this.getParameterValue(i.getValue())));
        parameterBinding.getQueryParams().forEach(i -> requestBuilder.addQueryParam(i.getKey(), this.getParameterValue(i.getValue())));
        return requestBuilder;
    }

    private String buildRequestPath(String pathTemplate, List<RequestParameterBinding.Binding> uriParams) {
        if (uriParams.isEmpty()) {
            return pathTemplate;
        }
        HashMap uriParamValues = new HashMap();
        uriParams.forEach(i -> uriParamValues.put(i.getKey(), this.getParameterValue(i.getValue())));
        String path = pathTemplate;
        for (String key : uriParamValues.keySet()) {
            path = path.replace("{" + key + "}", (CharSequence)uriParamValues.get(key));
        }
        return path;
    }

    private String getParameterValue(String expression) {
        return (String)this.expressionLanguage.evaluate(expression, DataType.STRING, this.buildContext(null, null)).getValue();
    }

    private BindingContext buildContext(TypedValue<?> payload, TypedValue<CursorStreamProvider> item) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", payload).addBinding("parameter", TypedValue.of(this.getParameterValues()));
        if (item != null) {
            builder.addBinding("item", item);
        }
        return builder.build();
    }

    protected abstract MultiMap<String, TypedValue<?>> getParameterValues();

    public Set<Value> resolve() throws ValueResolvingException {
        Result<TypedValue<String>, HttpResponseAttributes> result = RequestStreamingUtils.doRequestAndConsumeString(this.connection, this.config, this.getRestRequestBuilder(), this.getDefaultResponseMediaType());
        HashSet<Value> values = new HashSet<Value>();
        for (TypedValue<CursorStreamProvider> item : this.getItems((TypedValue<String>)((TypedValue)result.getOutput()))) {
            String itemValue;
            String itemName = itemValue = this.evaluateExpressionOnItem(item, this.itemValueExpression);
            if (RestSdkUtils.isNotBlank(this.itemNameExpression)) {
                itemName = this.evaluateExpressionOnItem(item, this.itemNameExpression);
            }
            values.add(ValueBuilder.newValue((String)itemValue).withDisplayName(itemName).build());
        }
        return values;
    }

    private String evaluateExpressionOnItem(TypedValue<CursorStreamProvider> item, String expression) {
        return (String)this.expressionLanguage.evaluate(expression, DataType.STRING, this.buildContext(null, item)).getValue();
    }

    protected MediaType getDefaultResponseMediaType() {
        return MediaType.APPLICATION_JSON;
    }

    private List<TypedValue<CursorStreamProvider>> getItems(TypedValue<String> payload) {
        TypedValue result = this.expressionLanguage.evaluate(this.itemsExpression, this.buildContext(payload, null));
        Iterator splitResult = this.expressionLanguage.split("#[payload default []]", this.buildContext(result, null));
        Iterable iterable = () -> splitResult;
        return StreamSupport.stream(iterable.spliterator(), false).map(RequestStreamingUtils::getCursorStreamProviderValueFromSplitResult).collect(Collectors.toList());
    }
}

