/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import static org.mule.metadata.api.utils.MetadataTypeUtils.isNotNull;

public class NumberHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof NumberSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager,
                               ParsingContext parsingContext) {
    final NumberSchema numberSchema = (NumberSchema) schema;
    final NumberTypeBuilder numberType = root.numberType();

    Number min = null;
    Number max = null;
    if (numberSchema.getMinimum() != null) {
      min = numberSchema.getMinimum();
    }
    if (numberSchema.getMaximum() != null) {
      max = numberSchema.getMaximum();
    }
    if (isNotNull(min) || isNotNull(max)) {
      numberType.range(min, max);
    }

    if (numberSchema.requiresInteger()) {
      numberType.integer();
    }
    return numberType;
  }
}
