/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.xml.api.SchemaCollector;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.util.IOUtils;

public final class RestSdkUtils {
    private RestSdkUtils() {
    }

    public static void closeAndRelease(CursorProvider cursorProvider) {
        cursorProvider.close();
        cursorProvider.releaseResources();
    }

    public static void closeStream(Object stream) {
        if (stream instanceof CursorProvider) {
            RestSdkUtils.closeAndRelease((CursorProvider)stream);
        } else if (stream instanceof InputStream) {
            IOUtils.closeQuietly((Closeable)((InputStream)stream));
        }
    }

    public static TypedValue<String> consumeStringAndClose(Object stream, MediaType targetMediaType, Charset targetCharset) {
        return RestSdkUtils.consumeStringTransformAndClose(stream, targetCharset, targetMediaType, targetCharset);
    }

    public static TypedValue<String> consumeStringTransformAndClose(Object stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        Either content;
        if (stream == null) {
            return RestSdkUtils.toTypedValue("", targetMediaType, targetCharset);
        }
        if (stream instanceof String) {
            return RestSdkUtils.toTypedValue((String)stream, targetMediaType, targetCharset);
        }
        if (stream instanceof CursorStreamProvider) {
            content = Either.left((Object)((CursorStreamProvider)stream));
        } else if (stream instanceof InputStream) {
            content = Either.right((Object)((InputStream)stream));
        } else {
            throw new IllegalArgumentException("Cannot consume stream of unsupported type: " + stream.getClass().getName());
        }
        return (TypedValue)content.reduce(provider -> {
            try {
                TypedValue<String> typedValue = RestSdkUtils.doConsumeAndClose((InputStream)provider.openCursor(), sourceCharset, targetMediaType, targetCharset);
                return typedValue;
            }
            finally {
                RestSdkUtils.closeAndRelease((CursorProvider)provider);
            }
        }, in -> RestSdkUtils.doConsumeAndClose(in, sourceCharset, targetMediaType, targetCharset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypedValue<String> doConsumeAndClose(InputStream stream, Charset sourceCharset, MediaType targetMediaType, Charset targetCharset) {
        try {
            TypedValue<String> typedValue = RestSdkUtils.toTypedValue(IOUtils.toString((InputStream)stream, (Charset)sourceCharset), targetMediaType, targetCharset);
            return typedValue;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    private static TypedValue<String> toTypedValue(String value, MediaType mediaType, Charset encoding) {
        return new TypedValue((Object)value, DataType.builder().mediaType(mediaType).charset(encoding).build());
    }

    public static boolean containsIgnoreCase(String value, String predicate) {
        if (value == null || predicate == null) {
            return false;
        }
        return value.toLowerCase().contains(predicate.toLowerCase());
    }

    public static boolean isNotBlank(String v) {
        return !RestSdkUtils.isBlank(v);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readSchema(ClassLoader classLoader, String schemaPath) {
        try (InputStream in = classLoader.getResourceAsStream(schemaPath);){
            if (in == null) {
                throw new IllegalArgumentException("Could not find schema at " + schemaPath);
            }
            String string = IOUtils.toString((InputStream)in);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MetadataType loadXmlSchema(ClassLoader classLoader, String schemaPath, String qName) {
        schemaPath = RestSdkUtils.makeRelativePath(schemaPath);
        String schemaContent = RestSdkUtils.readSchema(classLoader, schemaPath);
        URL schemaURL = classLoader.getResource(schemaPath);
        SchemaCollector schemaCollector = SchemaCollector.getInstance().addSchema(schemaURL.toString(), (InputStream)new ByteArrayInputStream(schemaContent.getBytes()));
        Optional metadataType = new XmlTypeLoader(schemaCollector).load(qName);
        if (!metadataType.isPresent()) {
            throw new RuntimeException("Could not load XML Schema " + schemaPath + " QName:" + qName);
        }
        return (MetadataType)metadataType.get();
    }

    public static MetadataType loadJsonSchema(ClassLoader classLoader, String schemaPath, MetadataFormat metadataFormat) {
        String schemaContent = RestSdkUtils.readSchema(classLoader, schemaPath = RestSdkUtils.makeRelativePath(schemaPath));
        Optional optionalMetadataType = new JsonTypeLoader(schemaContent).load(null);
        if (!optionalMetadataType.isPresent()) {
            throw new RuntimeException("Could not load Json Schema " + schemaPath);
        }
        MetadataType metadataType = (MetadataType)optionalMetadataType.get();
        try {
            RestSdkUtils.setMetadataFormat(metadataType, metadataFormat);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException("Could not set MetadataFormat to MetadataType", e);
        }
        return metadataType;
    }

    private static void setMetadataFormat(MetadataType metadataType, MetadataFormat newMetadataFormat) throws NoSuchFieldException, IllegalAccessException {
        Field metadataFormatField = BaseMetadataType.class.getDeclaredField("metadataFormat");
        metadataFormatField.setAccessible(true);
        metadataFormatField.set(metadataType, newMetadataFormat);
    }

    private static String makeRelativePath(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static List<TypedValue<String>> toList(Iterator<TypedValue<?>> iterator, MediaType mediaType, MediaType defaultMediaType) {
        LinkedList<TypedValue<String>> list = new LinkedList<TypedValue<String>>();
        Charset encoding = RestSdkUtils.resolveCharset(Optional.of(mediaType), defaultMediaType);
        iterator.forEachRemaining(v -> {
            TypedValue<String> stringTypedValue = v.getDataType().getMediaType().getCharset().isPresent() && ((Charset)v.getDataType().getMediaType().getCharset().get()).equals(encoding) ? RestSdkUtils.consumeStringAndClose(v.getValue(), mediaType, encoding) : RestSdkUtils.consumeStringTransformAndClose(v.getValue(), (Charset)v.getDataType().getMediaType().getCharset().get(), mediaType, encoding);
            list.add(stringTypedValue);
        });
        return list;
    }

    public static Charset resolveCharset(Optional<MediaType> mediaType, MediaType defaultMediaType) {
        return mediaType.flatMap(MediaType::getCharset).orElseGet(() -> defaultMediaType.getCharset().orElse(Charset.defaultCharset()));
    }

    public static TypedValue<?> getTypedValueOrNull(Object o) {
        return o != null ? TypedValue.of((Object)o) : null;
    }
}

