/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.ArgumentBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.BindingArgument;

/**
 * A fluent builder for binding arguments.
 *
 * @since 1.0
 */
public class BindingArgumentBuilder extends ArgumentBuilder<BindingArgument, BindingArgumentBuilder> {

  public BindingArgumentBuilder(String name) {
    super(name);
  }

  @Override
  protected BindingArgument build(String name, Expression expression) {
    return new BindingArgument(name, expression);
  }
}
