/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;

import java.util.function.Consumer;

/**
 * A fluent builder for different data expression types.
 *
 * @since 1.0
 */
public class DataExpressionBuilders {

  private DataExpressionBuilder<?> dataExpressionBuilder;

  public void http(Consumer<HttpRequestDataExpressionBuilder> consumer) {
    HttpRequestDataExpressionBuilder dataExpressionBuilder = new HttpRequestDataExpressionBuilder();
    consumer.accept(dataExpressionBuilder);
    this.dataExpressionBuilder = dataExpressionBuilder;
  }

  public void script(Consumer<ScriptDataExpressionBuilder> consumer) {
    ScriptDataExpressionBuilder dataExpressionBuilder = new ScriptDataExpressionBuilder();
    consumer.accept(dataExpressionBuilder);
    this.dataExpressionBuilder = dataExpressionBuilder;
  }

  public void seq(Consumer<SequenceCompositeDataExpressionBuilder> consumer) {
    SequenceCompositeDataExpressionBuilder dataExpressionBuilder = new SequenceCompositeDataExpressionBuilder();
    consumer.accept(dataExpressionBuilder);
    this.dataExpressionBuilder = dataExpressionBuilder;
  }

  public DataExpression build() {
    return dataExpressionBuilder.build();
  }
}
