/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.simpledata;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.DataExpressionBuilders;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.simpledata.SimpleDataResolverDefinition;

import java.util.function.Consumer;

/**
 * A fluent builder for a sample data resolver definition.
 *
 * @since 1.0
 */
public class SimpleDataResolverDefinitionBuilder extends ResolverDefinitionBuilder<SimpleDataResolverDefinition> {

  private DataExpressionBuilders resultDataExpressionBuilder;

  public SimpleDataResolverDefinitionBuilder result(Consumer<DataExpressionBuilders> consumer) {
    DataExpressionBuilders resultDataExpressionBuilder = new DataExpressionBuilders();
    consumer.accept(resultDataExpressionBuilder);
    this.resultDataExpressionBuilder = resultDataExpressionBuilder;
    return this;
  }

  private DataExpression buildResultExpression() {
    if (resultDataExpressionBuilder == null) {
      throw new IllegalStateException("No result expression set.");
    }
    return resultDataExpressionBuilder.build();
  }

  public SimpleDataResolverDefinition build() {
    return new SimpleDataResolverDefinition(buildResultExpression());
  }

}
