/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.simpledata;

import static com.mulesoft.connectivity.rest.commons.internal.util.ResolverUtil.createParentEvaluationContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.data.sample.SampleDataException;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.operation.Result;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.common.OperationEvaluationContextBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.simpledata.SimpleDataResolverExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Evaluable;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.adapter.SdkResultAdapter;

import java.util.Optional;

import javax.inject.Inject;

public abstract class RestSimpleDataProvider<T, A> implements SampleDataProvider<T, A> {

  @Config
  private RestConfiguration config;

  @Connection
  protected RestConnection connection;

  @Inject
  private ExpressionLanguage expressionLanguage;

  @Override
  public String getId() {
    return getClass().getSimpleName();
  }

  protected Optional<EvaluationContext> getGlobalEvaluationContext() {
    return Optional.empty();
  }

  protected abstract void build(SimpleDataResolverExpressionBuilder builder);

  private EvaluationContext createEvaluationContext() {
    EvaluationContext parentEvaluationContext = createParentEvaluationContext(getGlobalEvaluationContext().orElse(null),
                                                                              config, connection, expressionLanguage);

    OperationEvaluationContextBuilder operationContextBuilder = new OperationEvaluationContextBuilder(parentEvaluationContext);

    configureEvaluationContext(operationContextBuilder);
    return operationContextBuilder.build();
  }

  protected void configureGlobalEvaluationContext(EvaluationContext evaluationContext) {}

  protected void configureEvaluationContext(OperationEvaluationContextBuilder operationEvaluationContextBuilder) {}

  @Override
  public Result<T, A> getSample() throws SampleDataException {
    SimpleDataResolverExpressionBuilder builder = new SimpleDataResolverExpressionBuilder();
    build(builder);
    final Evaluable simpleDataResolverExpression = builder.build();
    final EvaluationContext evaluationContext = createEvaluationContext();
    final Object resultOutput = simpleDataResolverExpression.evaluate(evaluationContext);
    return SdkResultAdapter.from(resultOutput);
  }
}
