/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;

/**
 * An evaluable script data expression.
 *
 * @since 1.0
 */
public class ScriptDataExpression implements DataExpression {

  private final Expression scriptExpression;

  public ScriptDataExpression(Expression scriptExpression) {
    if (scriptExpression == null) {
      throw new IllegalArgumentException("Missing script expression.");
    }
    this.scriptExpression = scriptExpression;
  }

  @Override
  public Object evaluate(EvaluationContext evaluationContext) {
    return scriptExpression.evaluate(evaluationContext);
  }
}
