/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.simpledata;

import com.mulesoft.connectivity.rest.commons.internal.model.common.Evaluable;
import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverDefinition;

/**
 * The definition of a sample data implementations for the resolver framework.
 *
 * @since 1.0
 */
public class SimpleDataResolverDefinition extends ResolverDefinition implements Evaluable {

  private final DataExpression resultDataExpression;

  public SimpleDataResolverDefinition(DataExpression resultDataExpression) {
    this.resultDataExpression = resultDataExpression;
  }

  @Override
  public Object evaluate(EvaluationContext evaluationContext) {
    return resultDataExpression.evaluate(evaluationContext);
  }
}
