/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.common;

import com.mulesoft.connectivity.rest.commons.internal.model.common.Argument;
import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;

import java.util.function.Consumer;

/**
 * Base class for a fluent argument builder.
 * @param <T> The type of argument this builder builds.
 * @param <S> The argument builder class.
 *
 * @since 1.0
 */
public abstract class ArgumentBuilder<T extends Argument, S extends ArgumentBuilder<T, S>> {

  private final String name;
  private ExpressionBuilder value;

  public ArgumentBuilder(String name) {
    this.name = name;
  }

  public S value(Consumer<ExpressionBuilder> consumer) {
    ExpressionBuilder expressionBuilder = new ExpressionBuilder();
    consumer.accept(expressionBuilder);
    value = expressionBuilder;
    return (S) this;
  }

  public T build() {
    return build(buildName(), buildExpression());
  }

  protected abstract T build(String name, Expression expression);

  private String buildName() {
    return name;
  }

  private Expression buildExpression() {
    return value.build();
  }
}
