/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers;

import com.mulesoft.connectivity.rest.commons.internal.model.common.DataType;
import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverParameter;

/**
 * A builder for resolver parameters.
 *
 * @since 1.0
 */
public class ResolverParameterBuilder {

  private final String name;
  private DataType dataType;

  public ResolverParameterBuilder(String name) {
    this.name = name;
  }

  public ResolverParameterBuilder type(DataType dataType) {
    this.dataType = dataType;
    return this;
  }

  public ResolverParameter build() {
    return new ResolverParameter(name, dataType);
  }
}
