/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions;

import com.mulesoft.connectivity.rest.commons.internal.model.common.Expression;

import java.util.List;

/**
 * Describes the parameter bindings for an http request.
 * It can describe the uri, query and header parameters.
 * It can also describe the body for the http request.
 *
 * @since 1.0
 */
public class HttpRequestDataExpressionBinding {

  private final List<BindingArgument> headers;
  private final List<BindingArgument> uriParameters;
  private final List<BindingArgument> queryParameters;
  private final Expression body;

  public HttpRequestDataExpressionBinding(List<BindingArgument> headers, List<BindingArgument> uriParameters,
                                          List<BindingArgument> queryParameters, Expression body) {
    this.headers = headers;
    this.uriParameters = uriParameters;
    this.queryParameters = queryParameters;
    this.body = body;
  }

  public List<BindingArgument> getHeaders() {
    return headers;
  }

  public List<BindingArgument> getUriParameters() {
    return uriParameters;
  }

  public List<BindingArgument> getQueryParameters() {
    return queryParameters;
  }

  public Expression getBody() {
    return body;
  }
}
