/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.resolvers;

import com.mulesoft.connectivity.rest.commons.internal.model.common.EvaluationContext;

import java.util.List;

/**
 * A declaration of a resolver.
 * This includes the name, definition, and input parameters of the resolver.
 *
 * @param <T> The resolver definition type of this declaration.
 *
 * @since 1.0
 */
public class ResolverDeclaration<T extends ResolverDefinition> implements ResolverExpression {

  private final String name;
  private final List<ResolverParameter> parameters;
  private final T definition;

  public ResolverDeclaration(String name, List<ResolverParameter> parameters, T definition) {
    this.name = name;
    this.parameters = parameters;
    this.definition = definition;
  }

  public String getName() {
    return name;
  }

  public List<ResolverParameter> getParameters() {
    return parameters;
  }

  public T getDefinition() {
    return definition;
  }

  @Override
  public Object evaluate(EvaluationContext evaluationContext) {
    return definition.evaluate(evaluationContext);
  }
}
