/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.connection;

import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.sdk.api.annotation.semantics.connectivity.BasicAuth;

/**
 * Base class for connection providers which use basic authentication
 *
 * @since 1.0
 */
@BasicAuth
public abstract class BasicAuthenticationConnectionProvider extends BaseConnectionProvider {

  @Override
  protected HttpAuthentication buildAuthentication() {
    return HttpAuthentication.basic(getUsername(), getPassword()).build();
  }

  /**
   * Returns the username used to authenticate the requests that will be used to build the corresponding authentication.
   * 
   * @return The username used to authenticate the requests.
   */
  protected abstract String getUsername();

  /**
   * Returns the username used to authenticate the requests that will be used to build the corresponding authentication.
   * 
   * @return The username used to authenticate the requests.
   */
  protected abstract String getPassword();
}
