/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.common;

import static com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler.CUSTOM_FIELD_LOCATION;
import static com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils.findObjectLocation;
import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.loadJsonSchema;
import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.makeRelativePath;
import static com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils.readSchema;
import static java.util.Collections.singletonMap;
import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoaderConfiguration;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

public class TypeParameterResolverUtil {

  public static MetadataType resolveType(ExpressionLanguageMetadataService expressionLanguageMetadataService,
                                         String customFieldSchema, String selector,
                                         String schemaPath, MetadataFormat metadataFormat) {

    String schemaContent = readSchema(TypeParameterResolverUtil.class.getClassLoader(), makeRelativePath(schemaPath));

    MetadataType customFieldMetadataType = findCustomField(schemaContent, selector, expressionLanguageMetadataService);
    String customFieldLocation = customFieldMetadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).get().getValue()
        .get(CUSTOM_FIELD_LOCATION);

    MetadataType customFieldsType = new RestJsonTypeLoader(customFieldSchema).load(null).get();
    MetadataType extendedArgumentMetadataType =
        expressionLanguageMetadataService.intersect(Arrays.asList(customFieldMetadataType, customFieldsType));
    Map<String, MetadataType> substitutions = singletonMap(customFieldLocation, extendedArgumentMetadataType);

    MetadataType schemaMetadataType = loadSchema(schemaPath, RestJsonTypeLoaderConfiguration.builder()
        .traceCustomFieldLocation()
        .customField(customFieldLocation)
        .traceSubSchemaLocation()
        .build(), metadataFormat);

    MetadataType result =
        setMetadataFormat(expressionLanguageMetadataService.substitute(schemaMetadataType, substitutions), metadataFormat);
    return result;
  }

  private static MetadataType findCustomField(String schemaContent, String selector,
                                              ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    RestJsonTypeLoader restJsonTypeLoader =
        new RestJsonTypeLoader(schemaContent, RestJsonTypeLoaderConfiguration.builder().traceCustomFieldLocation().build());
    MetadataType metadataType1 = restJsonTypeLoader.load("id").orElse(null);
    MetadataType customField =
        expressionLanguageMetadataService.getOutputType(TypeBindings.builder().addBinding("payload", metadataType1).build(),
                                                        selector,
                                                        new ExpressionLanguageMetadataService.MessageCallback() {

                                                          @Override
                                                          public void warning(String message,
                                                                              ExpressionLanguageMetadataService.MessageLocation location) {}

                                                          @Override
                                                          public void error(String message,
                                                                            ExpressionLanguageMetadataService.MessageLocation location) {}
                                                        });
    return findObjectLocation(customField).get();
  }

  private static MetadataType loadSchema(String schemaPath, RestJsonTypeLoaderConfiguration configuration,
                                         MetadataFormat metadataFormat) {
    return loadJsonSchema(schemaContent -> new RestJsonTypeLoader(schemaContent, configuration),
                          TypeParameterResolverUtil.class.getClassLoader(), schemaPath, metadataFormat);
  }

  private static MetadataType setMetadataFormat(MetadataType metadataType, MetadataFormat newMetadataFormat) {
    try {
      Field metadataFormatField = BaseMetadataType.class.getDeclaredField("metadataFormat");
      metadataFormatField.setAccessible(true);
      metadataFormatField.set(metadataType, newMetadataFormat);
      return metadataType;
    } catch (Exception e) {
      throw new MuleRuntimeException(createStaticMessage("Error while setting metadata format"), e);
    }
  }

}
