/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.input;

import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.HashMap;
import java.util.Map;

public abstract class StringDateTimeFormatInputMetadataResolver extends PrimitiveInputMetadataResolver {

  private static final String FORMAT = "format";
  private static final String DATE_TIME = "date-time";

  protected abstract MetadataFormat getFormat();

  @Override
  public MetadataType getStaticMetadata() {
    Map<String, String> properties = new HashMap<>();
    properties.put(FORMAT, DATE_TIME);
    return BaseTypeBuilder.create(getFormat()).stringType().with(new MetadataFormatPropertiesAnnotation(properties)).build();
  }
}
