/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.output.customfields;

import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;

import com.mulesoft.connectivity.rest.commons.api.datasense.metadata.common.JsonCustomFieldsHttpMetadataResolver;
import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.SchemaInferenceUtils;

public abstract class JsonOutputCustomFieldsHttpMetadataResolver extends JsonCustomFieldsHttpMetadataResolver
    implements OutputTypeResolver<Object> {

  @Override
  public MetadataType getOutputType(MetadataContext metadataContext, Object key)
      throws MetadataResolvingException, ConnectionException {
    MetadataType metadataType = resolveMetadataType(metadataContext, key);
    if (shouldInferMetadata()) {
      metadataType = SchemaInferenceUtils.inferSchema(getConfiguration(metadataContext).getExpressionLanguageMetadataService(),
                                                      metadataType, getPageResponseExpression(),
                                                      MetadataUtils.LocationType.ARRAY);
    }
    if (hasPagination()) {
      metadataType = ((ArrayType) metadataType).getType();
    }
    return metadataType;
  }

  protected boolean hasPagination() {
    return false;
  }

  protected boolean shouldInferMetadata() {
    return false;
  }

  protected String getPageResponseExpression() {
    return null;
  }

}
