/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.dw;

public enum DWBindings {

  PARAMETERS("parameters"), URIS("uriParameters"), QUERIES("queryParameters"), HEADERS("headers"), BODY("body"), WATERMARK(
      "watermark"),

  RESPONSE("response"), PATH("path"), QUERY("query"), HEADER("header"),
  // Http Response Interceptor bindings (headers/body also used here)
  REQUEST("request"), STATUS_CODE("statusCode"), REASON_PHRASE("reasonPhrase"), MEDIATYPE("mediaType"), PAYLOAD("payload");

  private final String binding;

  DWBindings(String binding) {
    this.binding = binding;
  }

  public String getBinding() {
    return binding;
  }
}
