/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.dw;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.CaseInsensitiveMultiMap;

import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;

public class HttpResponseDWBinding {

  /**
   * HTTP status code of the response.
   */
  private final Integer statusCode;

  /**
   * Map of HTTP headers in the message.
   */
  private final MultiMap<String, String> header;

  /**
   * HTTP reason phrase of the response.
   */
  private final String reasonPhrase;

  /**
   * HTTP body of the response.
   */
  private final TypedValue<String> body;

  public HttpResponseDWBinding(TypedValue<String> payload, HttpResponseAttributes attributes) {
    if (attributes != null) {
      this.statusCode = attributes.getStatusCode();
      this.reasonPhrase = attributes.getReasonPhrase();
      this.header = new CaseInsensitiveMultiMap(attributes.getHeaders());
    } else {
      this.statusCode = null;
      this.reasonPhrase = null;
      this.header = emptyMultiMap();
    }
    this.body = payload;
  }

  public Integer getStatusCode() {
    return statusCode;
  }

  public MultiMap<String, String> getHeader() {
    return header;
  }

  public String getReasonPhrase() {
    return reasonPhrase;
  }

  public TypedValue<String> getBody() {
    return body;
  }
}
