/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

import java.net.URI;
import java.util.Map;

/**
 * An HttpRequest model than provides access to {@link #getUriParameters()}.
 *
 * @since 1.0
 */
public interface HttpRequest {

  Map<String, String> getUriParameters();

  HttpProtocol getProtocol();

  String getPath();

  String getMethod();

  URI getUri();

  MultiMap<String, String> getQueryParameters();

  HttpEntity getEntity();

  MultiMap<String, String> getHeaders();

}
