/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

/**
 * An interceptor to manipulate a server's HttpResponse before RSDK processes it and generates a
 * {@link org.mule.runtime.extension.api.runtime.operation.Result}. This would allow it to handle responses from SaaS that don't
 * signal errors with explicit response status or change the response content, reasonPhrase and even a status code if needed.
 *
 * @since 1.0
 */
@NoImplement
public interface HttpResponseInterceptor {

  /**
   * Process an {@link HttpResponse} and generate a new one or return the one provided.
   *
   * @param httpRequest the HTTP request that was executed against the server.
   * @param httpResponse the server response to be intercepted. Entity's content could not be read more than once, so
   *        implementations should address this when content needs to be accessed more than once.
   * @return the same or a new and modified {@link HttpResponse}.
   */
  default HttpResponse intercept(HttpRequest httpRequest, HttpResponse httpResponse) {
    return httpResponse;
  }

}
