/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor;

import org.mule.api.annotation.NoImplement;

import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder.HttpResponseInterceptorDescriptorBuilder;

/**
 * A descriptor that defines how to process to intercept a {@link org.mule.runtime.http.api.domain.message.response.HttpResponse}.
 *
 * @since 1.0
 */
@NoImplement
public abstract class HttpResponseInterceptorDescriptor {

  public abstract void accept(HttpResponseInterceptorDescriptorVisitor visitor);

  /**
   * @return a {@link HttpResponseInterceptorDescriptorBuilder} to create define an interceptor descriptor.
   */
  public static HttpResponseInterceptorDescriptorBuilder builder() {
    return new HttpResponseInterceptorDescriptorBuilder();
  }
}
