/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor;

import static java.util.Objects.requireNonNull;

public class PreconditionHttpResponseInterceptorDelegateDescriptor extends HttpResponseInterceptorDescriptor {

  private Matcher precondition;
  private HttpResponseInterceptorDescriptor delegateDescriptor;

  public PreconditionHttpResponseInterceptorDelegateDescriptor(Matcher precondition,
                                                               HttpResponseInterceptorDescriptor delegateDescriptor) {
    this.precondition = requireNonNull(precondition, "precondition cannot be null");
    this.delegateDescriptor = requireNonNull(delegateDescriptor, "delegateDescriptor cannot be null");
  }

  public Matcher getPrecondition() {
    return precondition;
  }

  public HttpResponseInterceptorDescriptor getDelegateDescriptor() {
    return delegateDescriptor;
  }

  /**
   * Defines a predicate condition.
   */
  public interface Matcher {

    boolean match(int statusCode);
  }

  @Override
  public void accept(HttpResponseInterceptorDescriptorVisitor visitor) {
    visitor.visit(this);
  }
}
