/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.ExpressionHttpResponseInterceptorDescriptor;

public class ExpressionHttpResponseInterceptorDescriptionBuilder {

  private String matchExpression;

  private String statusCodeExpression;
  private String reasonPhraseExpression;
  private String headersExpression;
  private String bodyExpression;

  /**
   * Sets the matching expression for this interceptor descriptor.
   *
   * @param matchExpression a DW expression that returns a boolean {@code true} if the interceptor should handle the response or
   *        not.
   * @return this
   */
  public ExpressionHttpResponseInterceptorDescriptionBuilder matchExpression(String matchExpression) {
    requireNonNull(matchExpression);
    this.matchExpression = matchExpression;
    return this;
  }

  /**
   * Sets the expression for resolving the status code.
   *
   * @param statusCodeExpression a DW expression that resolves the status code.
   * @return this
   */
  public ExpressionHttpResponseInterceptorDescriptionBuilder statusCodeExpression(String statusCodeExpression) {
    requireNonNull(statusCodeExpression);
    this.statusCodeExpression = statusCodeExpression;
    return this;
  }

  /**
   * Sets the expression for resolving the reason phrase.
   *
   * @param reasonPhraseExpression a DW expression that resolves the reason phrase.
   * @return this
   */
  public ExpressionHttpResponseInterceptorDescriptionBuilder reasonPhraseExpression(String reasonPhraseExpression) {
    requireNonNull(reasonPhraseExpression);
    this.reasonPhraseExpression = reasonPhraseExpression;
    return this;
  }

  /**
   * Sets the expression for resolving the headers.
   *
   * @param headersExpression a DW expression that resolves the headers.
   * @return this
   */
  public ExpressionHttpResponseInterceptorDescriptionBuilder headersExpression(String headersExpression) {
    requireNonNull(headersExpression);
    this.headersExpression = headersExpression;
    return this;
  }

  /**
   * Sets the expression for resolving the body.
   *
   * @param bodyExpression a DW expression that resolves the body.
   * @return this
   */
  public ExpressionHttpResponseInterceptorDescriptionBuilder bodyExpression(String bodyExpression) {
    requireNonNull(bodyExpression);
    this.bodyExpression = bodyExpression;
    return this;
  }

  ExpressionHttpResponseInterceptorDescriptor build() {
    return new ExpressionHttpResponseInterceptorDescriptor(matchExpression, statusCodeExpression, reasonPhraseExpression,
                                                           headersExpression,
                                                           bodyExpression);
  }

}
