/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.interception.descriptor.builder;

import static java.util.Objects.requireNonNull;

import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.HttpResponseInterceptorDescriptor;
import com.mulesoft.connectivity.rest.commons.api.interception.descriptor.PreconditionHttpResponseInterceptorDelegateDescriptor;

import java.util.function.Consumer;

public class PreconditionHttpResponseInterceptorDelegateDescriptorBuilder {

  private Matcher preconditionMatcher;
  private HttpResponseInterceptorDescriptorBuilder descriptorDelegateBuilder = new HttpResponseInterceptorDescriptorBuilder();

  public PreconditionHttpResponseInterceptorDelegateDescriptorBuilder(Matcher preconditionMatcher) {
    this.preconditionMatcher = requireNonNull(preconditionMatcher, "preconditionMatcher cannot be null");
  }

  public interface Matcher {

    boolean match(int statusCode);

  }

  /**
   * Defines a conditional descriptor, it gets added to the chain of interceptors.
   *
   * @param builderConfigurator the consumer to configure the conditional based interceptor.
   * @return this
   */
  public PreconditionHttpResponseInterceptorDelegateDescriptorBuilder expression(
                                                                                 Consumer<ExpressionHttpResponseInterceptorDescriptionBuilder> builderConfigurator) {
    descriptorDelegateBuilder = descriptorDelegateBuilder.expression(builderConfigurator);
    return this;
  }

  /**
   * @return builds the instance of the descriptor.
   * @throws {@link IllegalStateException} if an expression has not been defined.
   */
  public PreconditionHttpResponseInterceptorDelegateDescriptor build() {
    if (descriptorDelegateBuilder == null) {
      throw new IllegalStateException("There is no delegate interceptor descriptor defined for this conditional interceptor. This is probably a bug.");
    }
    HttpResponseInterceptorDescriptor delegateDescriptor = descriptorDelegateBuilder.build();
    return new PreconditionHttpResponseInterceptorDelegateDescriptor(statusCode -> preconditionMatcher.match(statusCode),
                                                                     delegateDescriptor);
  }
}
