/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.streaming;

import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;

import java.io.InputStream;

public interface StreamingHelper {

  /**
   * If the value is a repeatable streaming resource such as {@link java.io.InputStream},
   * {@link org.mule.runtime.api.streaming.bytes.CursorStream}, then an equivalent {@link CursorStreamProvider} is returned. For
   * {@link org.mule.runtime.api.streaming.bytes.CursorStream} values, the same {@link CursorStreamProvider} that already owns
   * that {@link org.mule.runtime.api.streaming.bytes.CursorStream} is used. For other streaming values, the operation's
   * repeatable streaming strategy will be used. If that strategy doesn't apply (e.g: the operation returns a PagingProvider but
   * the streaming resource is an InputStream), then the system's default matching strategy will be used instead.
   *
   * @param value a value which may be a repeatable streaming resource.
   * @return a CursorProvider or the same input value
   */
  CursorStreamProvider resolveCursorStreamProvider(InputStream value);
}
