/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception;

import static java.util.Objects.requireNonNull;

import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpRequest;
import com.mulesoft.connectivity.rest.commons.api.interception.HttpResponseInterceptor;

import java.util.List;

/**
 * A composite implementation for {@link HttpResponseInterceptor} that executes the list of {@link HttpResponseInterceptor}.
 *
 * @since 1.0
 */
public class CompositeHttpResponseInterceptor implements HttpResponseInterceptor {

  private List<HttpResponseInterceptor> httpResponseInterceptors;

  public CompositeHttpResponseInterceptor(List<HttpResponseInterceptor> httpResponseInterceptors) {
    requireNonNull(httpResponseInterceptors);

    this.httpResponseInterceptors = httpResponseInterceptors;
  }

  @Override
  public HttpResponse intercept(HttpRequest httpRequest, HttpResponse httpResponse) {
    for (HttpResponseInterceptor httpResponseInterceptor : httpResponseInterceptors) {
      httpResponse = httpResponseInterceptor.intercept(httpRequest, httpResponse);
    }
    return httpResponse;
  }
}
