/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.interception.model;

import static java.util.Collections.unmodifiableMap;
import static org.mule.runtime.api.util.MultiMap.unmodifiableMultiMap;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;

import com.mulesoft.connectivity.rest.commons.api.interception.HttpRequest;

import java.net.URI;
import java.util.Map;

public class DefaultHttpRequest implements HttpRequest {

  private org.mule.runtime.http.api.domain.message.request.HttpRequest delegate;
  private Map<String, String> uriParameters;

  public DefaultHttpRequest(org.mule.runtime.http.api.domain.message.request.HttpRequest delegate,
                            Map<String, String> uriParameter) {
    this.delegate = delegate;
    this.uriParameters = uriParameter;
  }

  @Override
  public Map<String, String> getUriParameters() {
    return unmodifiableMap(uriParameters);
  }

  @Override
  public HttpProtocol getProtocol() {
    return delegate.getProtocol();
  }

  @Override
  public String getPath() {
    return delegate.getPath();
  }

  @Override
  public String getMethod() {
    return delegate.getMethod();
  }

  @Override
  public URI getUri() {
    return delegate.getUri();
  }

  @Override
  public MultiMap<String, String> getQueryParameters() {
    return unmodifiableMultiMap(delegate.getQueryParams());
  }

  @Override
  public HttpEntity getEntity() {
    return delegate.getEntity();
  }

  @Override
  public MultiMap<String, String> getHeaders() {
    return unmodifiableMultiMap(delegate.getHeaders());
  }

}
