/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel;

public class RestJsonTypeLoaderConfiguration {

  private boolean traceCustomFieldLocation = false;
  private boolean traceSubSchemaLocation = false;

  private String customField;

  public static RestJsonTypeLoaderConfigurationBuilder builder() {
    return new RestJsonTypeLoaderConfigurationBuilder();
  }

  public boolean isTraceCustomFieldLocation() {
    return traceCustomFieldLocation;
  }

  public boolean isTraceSubSchemaLocation() {
    return traceSubSchemaLocation;
  }

  public String getCustomField() {
    return customField;
  }

  private RestJsonTypeLoaderConfiguration() {}

  public static class RestJsonTypeLoaderConfigurationBuilder {

    private RestJsonTypeLoaderConfiguration instance;

    private RestJsonTypeLoaderConfigurationBuilder() {
      this.instance = new RestJsonTypeLoaderConfiguration();
    }

    public RestJsonTypeLoaderConfigurationBuilder traceCustomFieldLocation() {
      this.instance.traceCustomFieldLocation = true;
      return this;
    }

    public RestJsonTypeLoaderConfigurationBuilder traceSubSchemaLocation() {
      this.instance.traceSubSchemaLocation = true;
      return this;
    }

    public RestJsonTypeLoaderConfigurationBuilder customField(String customField) {
      this.instance.customField = customField;
      return this;
    }

    public RestJsonTypeLoaderConfiguration build() {
      return instance;
    }

  }
}
