/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import static com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader.JSON;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.Arrays;
import java.util.List;

import org.everit.json.schema.Schema;

/**
 * This class is a copy of {@link org.mule.metadata.json.api.handler.HandlerManager} where the implementation of ObjectHandler is
 * overridden with a custom one.
 */
public class RestHandlerManager {

  protected final List<? extends SchemaHandler> handlers;

  public RestHandlerManager() {
    this.handlers = createSchemaHandlers();
  }

  protected List<? extends SchemaHandler> createSchemaHandlers() {
    return Arrays.asList(createArrayHandler(), createBooleanHandler(), createCombinedHandler(), createEmptyHandler(),
                         createEnumHandler(),
                         createNullHandler(), createNumberHandler(), createObjectHandler(), createReferenceHandler(),
                         createStringHandler());
  }

  protected SchemaHandler createStringHandler() {
    return new StringHandler();
  }

  protected SchemaHandler createReferenceHandler() {
    return new ReferenceHandler();
  }

  protected SchemaHandler createObjectHandler() {
    return new RestObjectHandler();
  }

  protected SchemaHandler createNumberHandler() {
    return new NumberHandler();
  }

  protected SchemaHandler createNullHandler() {
    return new NullHandler();
  }

  protected SchemaHandler createEnumHandler() {
    return new EnumHandler();
  }

  protected SchemaHandler createEmptyHandler() {
    return new EmptyHandler();
  }

  protected SchemaHandler createCombinedHandler() {
    return new CombinedHandler();
  }

  protected SchemaHandler createBooleanHandler() {
    return new BooleanHandler();
  }

  protected SchemaHandler createArrayHandler() {
    return new ArrayHandler();
  }

  public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
    if (parsingContext.isAlreadyBuild(schema)) {
      return parsingContext.getBuilder(schema).get();
    } else {
      for (SchemaHandler handler : handlers) {
        if (handler.handles(schema)) {
          return handler.handle(schema, BaseTypeBuilder.create(JSON), this, parsingContext);
        }
      }
      // If no type was detected we just generate any
      return BaseTypeBuilder.create(JSON).anyType();
    }
  }
}
