/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.everit.json.schema.Schema;

public interface SchemaHandler {

  public String CUSTOM_FIELD_LOCATION = "customFieldLocation";
  public String SUB_SCHEMA_LOCATION = "subSchemaLocation";

  boolean handles(Schema schema);

  TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext);

  default void processTracing(Schema schema, WithAnnotation typeBuilder, RestHandlerManager handlerManager,
                              ParsingContext parsingContext) {
    processTracing(schema, typeBuilder, handlerManager, parsingContext, Collections.emptyMap());
  }

  default void processTracing(Schema schema, WithAnnotation typeBuilder, RestHandlerManager handlerManager,
                              ParsingContext parsingContext, Map<String, String> extraProperties) {
    Map<String, String> properties = new HashMap<>();
    properties.putAll(extraProperties);
    if (parsingContext.getConfiguration().isTraceCustomFieldLocation() && isNotBlank(schema.getSchemaLocation())) {
      properties.put(CUSTOM_FIELD_LOCATION, schema.getSchemaLocation());
    }
    if (parsingContext.getConfiguration().isTraceSubSchemaLocation() && isNotBlank(schema.getSchemaLocation())) {
      properties.put(SUB_SCHEMA_LOCATION, schema.getSchemaLocation());
    }
    if (!properties.isEmpty()) {
      typeBuilder.with(new MetadataFormatPropertiesAnnotation(properties));
    }
  }
}
