/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions;

import org.mule.runtime.api.metadata.MediaType;

import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.HttpRequestDataExpressionBinding;

import java.util.Optional;
import java.util.function.Consumer;

/**
 * A fluent builder for an http request data expression.
 *
 * @since 1.0
 */
public class HttpRequestDataExpressionBuilder implements DataExpressionBuilder<HttpRequestDataExpression> {

  private String path;
  private String method;
  private String outputMediaType;
  private HttpRequestDataExpressionBindingBuilder httpRequestDataExpressionBindingBuilder;

  public HttpRequestDataExpressionBuilder() {
    httpRequestDataExpressionBindingBuilder = new HttpRequestDataExpressionBindingBuilder();
  }

  public HttpRequestDataExpressionBuilder path(String path) {
    this.path = path;
    return this;
  }

  public HttpRequestDataExpressionBuilder method(String method) {
    this.method = method;
    return this;
  }

  public HttpRequestDataExpressionBuilder outputMediaType(String outputMediaType) {
    this.outputMediaType = outputMediaType;
    return this;
  }

  public HttpRequestDataExpressionBuilder bindings(Consumer<HttpRequestDataExpressionBindingBuilder> consumer) {
    consumer.accept(httpRequestDataExpressionBindingBuilder);
    return this;
  }

  private String buildPath() {
    return Optional.ofNullable(path).orElse("");
  }

  private String buildMethod() {
    if (method == null) {
      throw new IllegalStateException("Method not provided");
    }
    return method;
  }

  private MediaType buildOutputMediaType() {
    if (outputMediaType != null) {
      return MediaType.parse(outputMediaType);
    }
    return MediaType.APPLICATION_JSON;
  }

  private HttpRequestDataExpressionBinding buildHttpRequestDataExpressionBinding() {
    return httpRequestDataExpressionBindingBuilder.build();
  }


  public HttpRequestDataExpression build() {
    return new HttpRequestDataExpression(buildPath(), buildMethod(), buildOutputMediaType(),
                                         buildHttpRequestDataExpressionBinding());
  }

}
