/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers;

import com.mulesoft.connectivity.rest.commons.internal.model.resolvers.ResolverExpression;

import java.util.function.Consumer;

/**
 * The base class for fluent resolver expression builders.
 *
 * @param <T> The resolver definition builder this expression builder will use internally and will expose as a consumer for fluent
 *        building.
 *
 * @since 1.0
 */
public abstract class ResolverExpressionBuilder<T extends ResolverDefinitionBuilder<?>> {

  private final T resolverDefinitionBuilder;
  private final ResolverReferenceBuilder resolverReferenceBuilder;

  private boolean definitionBuilt = false;

  public ResolverExpressionBuilder(T resolverDefinitionBuilder) {
    this.resolverDefinitionBuilder = resolverDefinitionBuilder;
    this.resolverReferenceBuilder = new ResolverReferenceBuilder();
  }

  public ResolverExpressionBuilder<T> definition(Consumer<T> consumer) {
    consumer.accept(resolverDefinitionBuilder);
    definitionBuilt = true;
    return this;
  }

  public ResolverExpressionBuilder<T> reference(Consumer<ResolverReferenceBuilder> consumer) {
    consumer.accept(resolverReferenceBuilder);
    return this;
  }

  public ResolverExpression build() {
    if (definitionBuilt) {
      return resolverDefinitionBuilder.build();
    } else {
      return resolverReferenceBuilder.build();
    }
  }
}
