/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static org.mule.runtime.api.connection.ConnectionValidationResult.failure;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;

/**
 * Utils class for validating connections
 *
 * @since 1.0
 */
public final class ConnectionValidationUtils {

  private ConnectionValidationUtils() {}

  /**
   * Generates a failed {@link ConnectionValidationResult}. This validation result cause will be a {@link ConnectionException}
   * with the indicated message set.
   * 
   * @param message The {@link ConnectionException} message
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionExceptionResult(String message) {
    return connectionExceptionResult(message, null);
  }

  /**
   * Generates a failed {@link ConnectionValidationResult}. This validation result cause will be a {@link ConnectionException}
   * with the indicated message set.
   * 
   * @param message the {@link ConnectionException} message.
   * @param cause the {@link ConnectionException} cause.
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionExceptionResult(String message, Throwable cause) {
    return connectionValidationResult(new ConnectionException(message, cause));
  }

  /**
   * Generates a failed {@link ConnectionValidationResult}.
   * 
   * @param e this will be te cause of the validation result failing.
   * @return a failed connection validation result.
   */
  public static ConnectionValidationResult connectionValidationResult(Exception e) {
    return failure("Test connection failed", e);
  }
}
