/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;


import static org.mule.runtime.core.api.util.StringUtils.splitAndTrim;

public class StringCaseUtils {

  private final static String SEPARATOR_CHARS = " -_.?!$%";

  public static String titleCase(String text) {
    return textCase(text, true);
  }

  public static String sentenceCase(String text) {
    return textCase(text, false);
  }

  public static String textCase(String text, boolean capitalizeAllWords) {
    if (text == null || text.length() == 0) {
      return text;
    }

    final String result = camelCaseSeparate(text);

    final String[] words = splitAndTrim(result, SEPARATOR_CHARS);

    if (words.length > 0) {
      if (capitalizeAllWords) {
        for (int i = 0; i < words.length; i++) {
          words[i] = capitalize(words[i]);
        }
      } else {
        words[0] = capitalize(words[0]);
      }
    }

    return String.join(" ", words);
  }

  private static String capitalize(String word) {
    if (word == null || word.length() == 0) {
      return word;
    }
    return Character.toUpperCase(word.charAt(0)) + word.substring(1, word.length());
  }

  private static String camelCaseSeparate(String text) {
    if (text == null || text.length() == 0) {
      return text;
    }

    String result = text
        .replaceAll("(\\D)(\\d)", "$1 $2") // non digit - digit
        .replaceAll("(\\d)(\\D)", "$1 $2") // digit - non digit
        .replaceAll("([A-Z])([A-Z])([a-z])", "$1 $2$3")
        .replaceAll("([a-z])([A-Z]+)", "$1 $2")
        .toLowerCase();
    return result;
  }
}
