/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.operation.paging;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.api.dw.HttpResponseDWBinding;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingProvider;
import com.mulesoft.connectivity.rest.commons.internal.util.LinkHeaderUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HypermediaPagingProvider
extends RestPagingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(HypermediaPagingProvider.class);
    private final String nextUrlExpression;
    private boolean firstPage = true;
    private String nextUrl;

    public HypermediaPagingProvider(String nextUrlExpression, Function<RestConnection, RestRequestBuilder> requestFactory, ExpressionLanguage expressionLanguage, String payloadExpression, MediaType defaultMediaType, Map<String, Object> parameterBindings, Map<String, Object> customParameterBindings, int responseTimeout) {
        super(requestFactory, expressionLanguage, payloadExpression, defaultMediaType, parameterBindings, customParameterBindings, responseTimeout);
        this.nextUrlExpression = nextUrlExpression;
    }

    @Override
    public void cleanPagingAttributes() {
        super.cleanPagingAttributes();
        this.firstPage = true;
    }

    @Override
    protected void configureRequest(RestRequestBuilder requestBuilder) {
        if (!this.firstPage) {
            if (RestSdkUtils.isBlank(this.nextUrl)) {
                this.stopPaging();
                return;
            }
            if (this.nextUrl.toLowerCase().startsWith("http")) {
                requestBuilder.clearQueryParams();
                requestBuilder.setFullUri(this.nextUrl);
            } else {
                requestBuilder.setPath(this.nextUrl);
            }
        }
    }

    @Override
    protected void onPage(List<TypedValue<String>> page, TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
        this.firstPage = false;
        if (RestSdkUtils.isBlank((CharSequence)rawPage.getValue())) {
            this.nextUrl = null;
            this.stopPaging();
        } else {
            this.nextUrl = this.extractNextUrl(rawPage, responseAttributes);
        }
    }

    private String extractNextUrl(TypedValue<String> rawPage, HttpResponseAttributes responseAttributes) {
        try {
            return (String)this.evaluate(rawPage, this.nextUrlExpression, DataType.STRING, responseAttributes).getValue();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Failed to extract nextUrl from expression: %s", this.nextUrlExpression)), (Throwable)e);
        }
    }

    @Override
    protected BindingContext toBindingContext(TypedValue<String> content, HttpResponseAttributes httpResponseAttributes) {
        BindingContext.Builder builder = BindingContext.builder().addBinding("payload", content);
        HttpResponseDWBinding httpResponseBinding = new HttpResponseDWBinding(content, httpResponseAttributes);
        builder.addBinding(DWBindings.RESPONSE.getBinding(), TypedValue.of((Object)httpResponseBinding));
        if (httpResponseAttributes != null) {
            builder.addBinding("attributes", TypedValue.of((Object)httpResponseAttributes));
            try {
                String linkHeader = (String)httpResponseAttributes.getHeaders().get((Object)"link");
                builder.addBinding("link", TypedValue.of(LinkHeaderUtils.buildLinkHeaderMap(linkHeader)));
            }
            catch (Exception e) {
                LOGGER.warn("Failed to parse Link header", (Throwable)e);
            }
        }
        return builder.build();
    }
}

