/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.valueprovider;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.HttpRequestDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.ScriptDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.valueprovider.ValueProviderResolverDefinition;
import java.util.function.Consumer;

public class ValueProviderResolverDefinitionBuilder
extends ResolverDefinitionBuilder<ValueProviderResolverDefinition> {
    private HttpRequestDataExpressionBuilder httpRequestDataExpressionBuilder;
    private ScriptDataExpressionBuilder scriptDataExpressionBuilder;
    private String itemExtractionExpression;
    private String itemNameExpression;
    private String itemValueExpression;

    public ValueProviderResolverDefinitionBuilder httpRequest(Consumer<HttpRequestDataExpressionBuilder> consumer) {
        HttpRequestDataExpressionBuilder builder = new HttpRequestDataExpressionBuilder();
        consumer.accept(builder);
        this.httpRequestDataExpressionBuilder = builder;
        return this;
    }

    public ValueProviderResolverDefinitionBuilder script(Consumer<ScriptDataExpressionBuilder> consumer) {
        ScriptDataExpressionBuilder builder = new ScriptDataExpressionBuilder();
        consumer.accept(builder);
        this.scriptDataExpressionBuilder = builder;
        return this;
    }

    public ValueProviderResolverDefinitionBuilder itemExtractionExpression(String itemExtractionExpression) {
        this.itemExtractionExpression = itemExtractionExpression;
        return this;
    }

    public ValueProviderResolverDefinitionBuilder itemNameExpression(String itemNameExpression) {
        this.itemNameExpression = itemNameExpression;
        return this;
    }

    public ValueProviderResolverDefinitionBuilder itemValueExpression(String itemValueExpression) {
        this.itemValueExpression = itemValueExpression;
        return this;
    }

    private DataExpression buildDataExpression() {
        if (this.httpRequestDataExpressionBuilder != null) {
            return this.httpRequestDataExpressionBuilder.build();
        }
        if (this.scriptDataExpressionBuilder != null) {
            return this.scriptDataExpressionBuilder.build();
        }
        throw new IllegalStateException("No data expression set.");
    }

    private String buildItemExtraction() {
        if (this.itemExtractionExpression == null) {
            throw new IllegalStateException("No item extraction expression set.");
        }
        return this.itemExtractionExpression;
    }

    private String buildItemName() {
        return this.itemNameExpression;
    }

    private String buildItemValue() {
        if (this.itemValueExpression == null) {
            throw new IllegalStateException("No item value expression set.");
        }
        return this.itemValueExpression;
    }

    @Override
    public ValueProviderResolverDefinition build() {
        return new ValueProviderResolverDefinition(this.buildDataExpression(), this.buildItemExtraction(), this.buildItemName(), this.buildItemValue());
    }
}

