/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.api.dw;

import org.mule.runtime.api.util.MultiMap;

public class HttpRequestDWBinding {

  /**
   * Path parameters to be sent in the HTTP request.
   */
  private final MultiMap<String, Object> path;

  /**
   * Queries parameters to be sent in the HTTP request.
   */
  private final MultiMap<String, Object> query;

  /**
   * Headers to be sent in the HTTP request.
   */
  protected final MultiMap<String, Object> header;

  public HttpRequestDWBinding(MultiMap<String, Object> path, MultiMap<String, Object> query, MultiMap<String, Object> header) {
    this.path = path;
    this.query = query;
    this.header = header;
  }

  public MultiMap<String, Object> getPath() {
    return path;
  }

  public MultiMap<String, Object> getQuery() {
    return query;
  }

  public MultiMap<String, Object> getHeader() {
    return header;
  }
}
