/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.model.builder.sampledata;

import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.HttpRequestDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.ScriptDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.dataexpressions.SequenceCompositeDataExpressionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.builder.resolvers.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.commons.internal.model.dataexpressions.DataExpression;
import com.mulesoft.connectivity.rest.commons.internal.model.sampledata.SampleDataResolverDefinition;

import java.util.function.Consumer;

/**
 * A fluent builder for a sample data resolver definition.
 *
 * @since 1.0
 */
public class SampleDataResolverDefinitionBuilder extends ResolverDefinitionBuilder<SampleDataResolverDefinition> {

  private HttpRequestDataExpressionBuilder resultDataExpressionBuilder;
  private ScriptDataExpressionBuilder transformDataExpressionBuilder;
  private ScriptDataExpressionBuilder scriptDataExpressionBuilder;

  public SampleDataResolverDefinitionBuilder result(Consumer<HttpRequestDataExpressionBuilder> consumer) {
    HttpRequestDataExpressionBuilder builder = new HttpRequestDataExpressionBuilder();
    consumer.accept(builder);
    this.resultDataExpressionBuilder = builder;
    return this;
  }

  public SampleDataResolverDefinitionBuilder transform(Consumer<ScriptDataExpressionBuilder> consumer) {
    ScriptDataExpressionBuilder builder = new ScriptDataExpressionBuilder();
    consumer.accept(builder);
    this.transformDataExpressionBuilder = builder;
    return this;
  }

  public SampleDataResolverDefinitionBuilder script(Consumer<ScriptDataExpressionBuilder> consumer) {
    ScriptDataExpressionBuilder builder = new ScriptDataExpressionBuilder();
    consumer.accept(builder);
    this.scriptDataExpressionBuilder = builder;
    return this;
  }

  private DataExpression buildResultExpression() {
    SequenceCompositeDataExpressionBuilder sequenceBuilder = new SequenceCompositeDataExpressionBuilder();
    if (resultDataExpressionBuilder != null) {
      sequenceBuilder.step(stepBuilder -> stepBuilder.withDataExpression(resultDataExpressionBuilder.build()));
      if (transformDataExpressionBuilder != null) {
        sequenceBuilder.step(stepBuilder -> stepBuilder.withDataExpression(transformDataExpressionBuilder.build()));
      }
    } else if (scriptDataExpressionBuilder != null) {
      sequenceBuilder.step(stepBuilder -> stepBuilder.withDataExpression(scriptDataExpressionBuilder.build()));
    } else {
      throw new IllegalStateException("No result expression set.");
    }
    return sequenceBuilder.build();
  }

  public SampleDataResolverDefinition build() {
    return new SampleDataResolverDefinition(buildResultExpression());
  }

}
