/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import static com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler.SUB_SCHEMA_LOCATION;

import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;

public class SchemaInferenceUtils {

  public static MetadataType inferSchema(ExpressionLanguageMetadataService metadataService, MetadataType metadataType,
                                         String expression, MetadataUtils.LocationType locationType) {

    ObjectTypeBuilder response = BaseTypeBuilder.create(MetadataFormat.JSON).objectType();
    response.addField().key(DWBindings.BODY.getBinding()).value(metadataType);

    TypeBindings typeBindings = TypeBindings.builder()
        .addBinding(DWBindings.PAYLOAD.getBinding(), metadataType)
        .addBinding(DWBindings.RESPONSE.getBinding(), response.build())
        .build();

    MetadataType outputType =
        metadataService.getOutputType(typeBindings, curateScript(expression),
                                      new ExpressionLanguageMetadataService.MessageCallback() {

                                        @Override
                                        public void warning(String message,
                                                            ExpressionLanguageMetadataService.MessageLocation location) {}

                                        @Override
                                        public void error(String message,
                                                          ExpressionLanguageMetadataService.MessageLocation location) {}
                                      });
    return findLocation(outputType, locationType);
  }

  private static MetadataType findLocation(MetadataType metadataType, MetadataUtils.LocationType locationType) {
    MetadataUtils.ObjectHolder<MetadataType> objectHolder = new MetadataUtils.ObjectHolder<>(null);
    metadataType.accept(new MetadataTypeVisitor() {

      @Override
      public void visitArrayType(ArrayType arrayType) {
        super.visitArrayType(arrayType);
        setLocation(MetadataUtils.LocationType.ITEM.equals(locationType) ? arrayType.getType() : arrayType);
      }

      @Override
      public void visitUnion(UnionType unionType) {
        super.visitUnion(unionType);
        unionType.getTypes().forEach(metadataType1 -> metadataType1.accept(this));
      }

      @Override
      public void visitIntersection(IntersectionType intersectionType) {
        super.visitIntersection(intersectionType);
        intersectionType.getTypes().forEach(metadataType1 -> metadataType1.accept(this));
      }

      @Override
      public void visitTuple(TupleType tupleType) {
        super.visitTuple(tupleType);
        tupleType.getTypes().forEach(metadataType1 -> metadataType1.accept(this));
      }

      private void setLocation(MetadataType metadataType) {
        if (getSubSchemaLocation(metadataType) != null) {
          objectHolder.set(metadataType);
        }
      }

    });
    return objectHolder.get();
  }

  private static String getSubSchemaLocation(MetadataType metadataType) {
    return metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class)
        .map(MetadataFormatPropertiesAnnotation::getValue)
        .map(f -> f.get(SUB_SCHEMA_LOCATION))
        .orElse(null);
  }

  public static String curateScript(String script) {
    String trimmedScript = script.trim();
    if (trimmedScript.startsWith("#[") && trimmedScript.endsWith("]")) {
      trimmedScript = trimmedScript.substring(2, trimmedScript.length() - 1);
    }
    return trimmedScript;
  }
}
