/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.api.datasense.metadata.common;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoaderConfiguration;
import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class TypeParameterResolverUtil {
    public static MetadataType resolveType(ExpressionLanguageMetadataService expressionLanguageMetadataService, String customFieldSchema, String selector, String schemaPath, MetadataFormat metadataFormat) {
        String schemaContent = RestSdkUtils.readSchema(TypeParameterResolverUtil.class.getClassLoader(), RestSdkUtils.makeRelativePath(schemaPath));
        MetadataType customFieldMetadataType = TypeParameterResolverUtil.findCustomField(schemaContent, selector, expressionLanguageMetadataService);
        String customFieldLocation = (String)((MetadataFormatPropertiesAnnotation)customFieldMetadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).get()).getValue().get("customFieldLocation");
        MetadataType customFieldsType = new RestJsonTypeLoader(customFieldSchema).load(null).get();
        MetadataType extendedArgumentMetadataType = expressionLanguageMetadataService.intersect(Arrays.asList(customFieldMetadataType, customFieldsType));
        Map<String, MetadataType> substitutions = Collections.singletonMap(customFieldLocation, extendedArgumentMetadataType);
        MetadataType schemaMetadataType = TypeParameterResolverUtil.loadSchema(schemaPath, RestJsonTypeLoaderConfiguration.builder().traceCustomFieldLocation().customField(customFieldLocation).traceSubSchemaLocation().build(), metadataFormat);
        MetadataType result = TypeParameterResolverUtil.setMetadataFormat(expressionLanguageMetadataService.substitute(schemaMetadataType, substitutions), metadataFormat);
        return result;
    }

    private static MetadataType findCustomField(String schemaContent, String selector, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        RestJsonTypeLoader restJsonTypeLoader = new RestJsonTypeLoader(schemaContent, RestJsonTypeLoaderConfiguration.builder().traceCustomFieldLocation().build());
        MetadataType metadataType1 = restJsonTypeLoader.load("id").orElse(null);
        MetadataType customField = expressionLanguageMetadataService.getOutputType(TypeBindings.builder().addBinding("payload", metadataType1).build(), selector, new ExpressionLanguageMetadataService.MessageCallback(){

            public void warning(String message, ExpressionLanguageMetadataService.MessageLocation location) {
            }

            public void error(String message, ExpressionLanguageMetadataService.MessageLocation location) {
            }
        });
        return MetadataUtils.findObjectLocation(customField).get();
    }

    private static MetadataType loadSchema(String schemaPath, RestJsonTypeLoaderConfiguration configuration, MetadataFormat metadataFormat) {
        return RestSdkUtils.loadJsonSchema(schemaContent -> new RestJsonTypeLoader((String)schemaContent, configuration), TypeParameterResolverUtil.class.getClassLoader(), schemaPath, metadataFormat);
    }

    private static MetadataType setMetadataFormat(MetadataType metadataType, MetadataFormat newMetadataFormat) {
        try {
            Field metadataFormatField = BaseMetadataType.class.getDeclaredField("metadataFormat");
            metadataFormatField.setAccessible(true);
            metadataFormatField.set(metadataType, newMetadataFormat);
            return metadataType;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while setting metadata format"), (Throwable)e);
        }
    }
}

