/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestObjectHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.EnumSchema;
import org.everit.json.schema.NullSchema;
import org.everit.json.schema.Schema;
import org.everit.json.schema.StringSchema;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;

public class CombinedHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof CombinedSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        CombinedSchema combinedSchema = (CombinedSchema)schema;
        Collection subSchemas = combinedSchema.getSubschemas();
        if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
            ArrayList<Schema> uniqueSubSchemas = new ArrayList<Schema>();
            if (subSchemas.size() == 1) {
                return handlerManager.handle((Schema)subSchemas.stream().findFirst().get(), parsingContext);
            }
            for (Object subSchema : subSchemas) {
                if (subSchema instanceof NullSchema) continue;
                uniqueSubSchemas.add((Schema)subSchema);
            }
            if (uniqueSubSchemas.size() == 1) {
                return handlerManager.handle((Schema)uniqueSubSchemas.get(0), parsingContext);
            }
            UnionTypeBuilder unionType = root.unionType();
            for (Schema subSchema : uniqueSubSchemas) {
                unionType.of(handlerManager.handle(subSchema, parsingContext));
            }
            HashMap<String, String> formatProperties = new HashMap<String, String>();
            if (CombinedSchema.ONE_CRITERION == combinedSchema.getCriterion()) {
                formatProperties.put("exclusive", "true");
            }
            if (!formatProperties.isEmpty()) {
                unionType.with((TypeAnnotation)new MetadataFormatPropertiesAnnotation(formatProperties));
            }
            return unionType;
        }
        if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            IntersectionTypeBuilder typeBuilder;
            ArrayList<Schema> uniqueSubSchemas = new ArrayList<Schema>();
            if (subSchemas.size() == 2) {
                boolean enumSchemaPresent = subSchemas.stream().anyMatch(currentSubSchema -> currentSubSchema instanceof EnumSchema);
                boolean stringSchemaPresent = subSchemas.stream().anyMatch(currentSubSchema -> currentSubSchema instanceof StringSchema);
                for (Schema subSchema : subSchemas) {
                    if ((!enumSchemaPresent || !stringSchemaPresent || !(subSchema instanceof EnumSchema)) && (!enumSchemaPresent || stringSchemaPresent || subSchema instanceof EnumSchema)) continue;
                    uniqueSubSchemas.add(subSchema);
                }
                if (uniqueSubSchemas.isEmpty()) {
                    uniqueSubSchemas.addAll(subSchemas);
                }
            } else {
                uniqueSubSchemas.addAll(subSchemas);
            }
            if (uniqueSubSchemas.size() == 1) {
                typeBuilder = handlerManager.handle((Schema)uniqueSubSchemas.iterator().next(), parsingContext);
            } else if (uniqueSubSchemas.size() == 0) {
                typeBuilder = root.anyType();
            } else {
                IntersectionTypeBuilder intersectionType = root.intersectionType();
                RestObjectHandler.nonBlank(schema.getTitle()).ifPresent(title -> intersectionType.with((TypeAnnotation)new LabelAnnotation(title)));
                for (Schema subSchema : uniqueSubSchemas) {
                    intersectionType.of(handlerManager.handle(subSchema, parsingContext));
                }
                typeBuilder = intersectionType;
            }
            return typeBuilder;
        }
        return root.anyType();
    }
}

