/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.RestJsonTypeLoader;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ArrayHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.BooleanHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.CombinedHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.EmptyHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.EnumHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.NullHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.NumberHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ReferenceHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestObjectHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.StringHandler;
import java.util.Arrays;
import java.util.List;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

public class RestHandlerManager {
    protected final List<? extends SchemaHandler> handlers = this.createSchemaHandlers();

    protected List<? extends SchemaHandler> createSchemaHandlers() {
        return Arrays.asList(this.createArrayHandler(), this.createBooleanHandler(), this.createCombinedHandler(), this.createEmptyHandler(), this.createEnumHandler(), this.createNullHandler(), this.createNumberHandler(), this.createObjectHandler(), this.createReferenceHandler(), this.createStringHandler());
    }

    protected SchemaHandler createStringHandler() {
        return new StringHandler();
    }

    protected SchemaHandler createReferenceHandler() {
        return new ReferenceHandler();
    }

    protected SchemaHandler createObjectHandler() {
        return new RestObjectHandler();
    }

    protected SchemaHandler createNumberHandler() {
        return new NumberHandler();
    }

    protected SchemaHandler createNullHandler() {
        return new NullHandler();
    }

    protected SchemaHandler createEnumHandler() {
        return new EnumHandler();
    }

    protected SchemaHandler createEmptyHandler() {
        return new EmptyHandler();
    }

    protected SchemaHandler createCombinedHandler() {
        return new CombinedHandler();
    }

    protected SchemaHandler createBooleanHandler() {
        return new BooleanHandler();
    }

    protected SchemaHandler createArrayHandler() {
        return new ArrayHandler();
    }

    public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
        if (parsingContext.isAlreadyBuild(schema)) {
            return parsingContext.getBuilder(schema).get();
        }
        for (SchemaHandler schemaHandler : this.handlers) {
            if (!schemaHandler.handles(schema)) continue;
            return schemaHandler.handle(schema, BaseTypeBuilder.create((MetadataFormat)RestJsonTypeLoader.JSON), this, parsingContext);
        }
        return BaseTypeBuilder.create((MetadataFormat)RestJsonTypeLoader.JSON).anyType();
    }
}

