/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import java.util.Optional;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class MetadataUtils {
    public static Optional<MetadataType> findObjectLocation(MetadataType metadataType) {
        final ObjectHolder<Object> objectHolder = new ObjectHolder<Object>(null);
        metadataType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                this.processLocation(metadataType);
            }

            private void processLocation(MetadataType metadataType) {
                String location = MetadataUtils.getCustomFieldLocation(metadataType);
                if (location != null) {
                    if (this.overrideLocation(location)) {
                        throw new IllegalStateException(String.format("Attempt to override location [%s] with [%s].", this.getLocation().get(), location));
                    }
                    this.setLocation(metadataType);
                }
            }

            private boolean overrideLocation(String location) {
                return this.getLocation().isPresent() && !location.equals(MetadataUtils.getCustomFieldLocation(this.getLocation().get()));
            }

            private Optional<MetadataType> getLocation() {
                return Optional.ofNullable(objectHolder.get());
            }

            private void setLocation(MetadataType metadataType) {
                objectHolder.set(metadataType);
            }

            public void visitIntersection(IntersectionType intersectionType) {
                super.visitIntersection(intersectionType);
                if (!this.getLocation().isPresent()) {
                    intersectionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
                }
            }

            public void visitUnion(UnionType unionType) {
                super.visitUnion(unionType);
                if (!this.getLocation().isPresent()) {
                    unionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                super.visitArrayType(arrayType);
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }
        });
        return Optional.ofNullable(objectHolder.get());
    }

    private static String getCustomFieldLocation(MetadataType metadataType) {
        return metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).map(MetadataFormatPropertiesAnnotation::getValue).map(properties -> (String)properties.get("customFieldLocation")).orElse(null);
    }

    public static class ObjectHolder<T> {
        private T obj;

        public ObjectHolder(T obj) {
            this.obj = obj;
        }

        public T get() {
            return this.obj;
        }

        public void set(T obj) {
            this.obj = obj;
        }
    }

    public static enum LocationType {
        ITEM,
        ARRAY;

    }
}

