/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import com.mulesoft.connectivity.rest.commons.api.dw.DWBindings;
import com.mulesoft.connectivity.rest.commons.internal.util.MetadataUtils;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class SchemaInferenceUtils {
    public static MetadataType inferSchema(ExpressionLanguageMetadataService metadataService, MetadataType metadataType, String expression, MetadataUtils.LocationType locationType) {
        ObjectTypeBuilder response = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).objectType();
        response.addField().key(DWBindings.BODY.getBinding()).value(metadataType);
        TypeBindings typeBindings = TypeBindings.builder().addBinding(DWBindings.PAYLOAD.getBinding(), metadataType).addBinding(DWBindings.RESPONSE.getBinding(), (MetadataType)response.build()).build();
        MetadataType outputType = metadataService.getOutputType(typeBindings, SchemaInferenceUtils.curateScript(expression), new ExpressionLanguageMetadataService.MessageCallback(){

            public void warning(String message, ExpressionLanguageMetadataService.MessageLocation location) {
            }

            public void error(String message, ExpressionLanguageMetadataService.MessageLocation location) {
            }
        });
        return SchemaInferenceUtils.findLocation(outputType, locationType);
    }

    private static MetadataType findLocation(MetadataType metadataType, final MetadataUtils.LocationType locationType) {
        final MetadataUtils.ObjectHolder<Object> objectHolder = new MetadataUtils.ObjectHolder<Object>(null);
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                super.visitArrayType(arrayType);
                this.setLocation((MetadataType)(MetadataUtils.LocationType.ITEM.equals((Object)locationType) ? arrayType.getType() : arrayType));
            }

            public void visitUnion(UnionType unionType) {
                super.visitUnion(unionType);
                unionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            public void visitIntersection(IntersectionType intersectionType) {
                super.visitIntersection(intersectionType);
                intersectionType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            public void visitTuple(TupleType tupleType) {
                super.visitTuple(tupleType);
                tupleType.getTypes().forEach(metadataType1 -> metadataType1.accept((MetadataTypeVisitor)this));
            }

            private void setLocation(MetadataType metadataType) {
                if (SchemaInferenceUtils.getSubSchemaLocation(metadataType) != null) {
                    objectHolder.set(metadataType);
                }
            }
        });
        return objectHolder.get();
    }

    private static String getSubSchemaLocation(MetadataType metadataType) {
        return metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).map(MetadataFormatPropertiesAnnotation::getValue).map(f -> (String)f.get("subSchemaLocation")).orElse(null);
    }

    public static String curateScript(String script) {
        String trimmedScript = script.trim();
        if (trimmedScript.startsWith("#[") && trimmedScript.endsWith("]")) {
            trimmedScript = trimmedScript.substring(2, trimmedScript.length() - 1);
        }
        return trimmedScript;
    }
}

